package gov.va.med.mhv.sm.admin.enums;

public enum AddresseeRoleEnum {

	SENDER (0L, "sender"),
	RECIPIENT (1L, "recipient"),
	CC (2L, "cc"),
	BCC (3L, "bcc"),
	CC_SURROGATE(4L,"cc_surrogate");
	
	
	private Long id;
	private String name;
	
	private AddresseeRoleEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static AddresseeRoleEnum valueOf(Long value){
		for(AddresseeRoleEnum f : AddresseeRoleEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no adressee role found");
	}
	
}
